package gov.va.med.mhv.admin.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

import gov.va.med.mhv.admin.dto.UserAcceptTermsHistDTO;
import gov.va.med.mhv.admin.model.UserAcceptTermsHist;

@Component
public class UserAcceptTermsHistConverter {

	public UserAcceptTermsHistDTO convertFrom(UserAcceptTermsHist e) {
		UserAcceptTermsHistDTO enDTO = new UserAcceptTermsHistDTO();
		enDTO.setId(e.getId());
		enDTO.setUserUpdatedTime(e.getUserUpdatedTime());
		enDTO.setAccepted(e.getAccepted());
		enDTO.setUserProfileId(e.getUserProfileId());
		enDTO.setTermsCondVerHistId(e.getTermsCondVerHistId());
		return enDTO;
	}

	public UserAcceptTermsHist convertTo(UserAcceptTermsHistDTO enDto) {
		UserAcceptTermsHist e = new UserAcceptTermsHist();
		e.setId(enDto.getId());
		e.setUserUpdatedTime(enDto.getUserUpdatedTime());
		e.setAccepted(enDto.getAccepted());
		e.setUserProfileId(enDto.getUserProfileId());
		e.setTermsCondVerHistId(enDto.getTermsCondVerHistId());
		return e;
	}

	public List<UserAcceptTermsHistDTO> convertList(List<UserAcceptTermsHist> userAcceptTermHistList) {
		List<UserAcceptTermsHistDTO> list = new ArrayList<UserAcceptTermsHistDTO>();

		if (userAcceptTermHistList != null) {
			for (UserAcceptTermsHist listItem : userAcceptTermHistList) {
				UserAcceptTermsHistDTO dto = convertFrom(listItem);
				list.add(dto);
			}
		}

		return list;
	}

}
